//*****************************************************************************
//*****************************************************************************
//  FILENAME: QP1B.h
//   Version: 2.3, Updated on 2004/07/29 at 17:41:18
//  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
//
//  DESCRIPTION: Counter8 User Module C Language interface file
//               for the 22/24/27/29xxx PSoC family of devices
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************

#include <m8c.h>

#pragma fastcall16 QP1B_EnableInt
#pragma fastcall16 QP1B_DisableInt
#pragma fastcall16 QP1B_Start
#pragma fastcall16 QP1B_Stop
#pragma fastcall16 QP1B_bReadCounter              // Read  DR0
#pragma fastcall16 QP1B_WritePeriod               // Write DR1
#pragma fastcall16 QP1B_bReadCompareValue         // Read  DR2
#pragma fastcall16 QP1B_WriteCompareValue         // Write DR2

// The following symbols are deprecated.
// They may be omitted in future releases
//
#pragma fastcall16 bQP1B_ReadCounter              // Read  DR0 (Deprecated)
#pragma fastcall16 bQP1B_ReadCompareValue         // Read  DR2 (Deprecated)


//-------------------------------------------------
// Prototypes of the QP1B API.
//-------------------------------------------------

extern void QP1B_EnableInt(void);                           // Proxy Class 1
extern void QP1B_DisableInt(void);                          // Proxy Class 1
extern void QP1B_Start(void);                               // Proxy Class 1
extern void QP1B_Stop(void);                                // Proxy Class 1
extern BYTE QP1B_bReadCounter(void);                        // Proxy Class 1
extern void QP1B_WritePeriod(BYTE bPeriod);                 // Proxy Class 1
extern BYTE QP1B_bReadCompareValue(void);                   // Proxy Class 2
extern void QP1B_WriteCompareValue(BYTE bCompareValue);     // Proxy Class 1

// The following functions are deprecated.
// They may be omitted in future releases
//
extern BYTE bQP1B_ReadCounter(void);            // Deprecated
extern BYTE bQP1B_ReadCompareValue(void);       // Deprecated


//--------------------------------------------------
// Constants for QP1B API's.
//--------------------------------------------------

#define QP1B_CONTROL_REG_START_BIT             ( 0x01 )
#define QP1B_INT_REG_ADDR                      ( 0x0df )
#define QP1B_INT_MASK                          ( 0x80 )


//--------------------------------------------------
// Constants for QP1B user defined values
//--------------------------------------------------

#define QP1B_PERIOD                            ( 0xff )
#define QP1B_COMPARE_VALUE                     ( 0x00 )


//-------------------------------------------------
// Register Addresses for QP1B
//-------------------------------------------------

#pragma ioport  QP1B_COUNTER_REG:   0x05c                  //DR0 Count register
BYTE            QP1B_COUNTER_REG;
#pragma ioport  QP1B_PERIOD_REG:    0x05d                  //DR1 Period register
BYTE            QP1B_PERIOD_REG;
#pragma ioport  QP1B_COMPARE_REG:   0x05e                  //DR2 Compare register
BYTE            QP1B_COMPARE_REG;
#pragma ioport  QP1B_CONTROL_REG:   0x05f                  //Control register
BYTE            QP1B_CONTROL_REG;
#pragma ioport  QP1B_FUNC_REG:  0x15c                      //Function register
BYTE            QP1B_FUNC_REG;
#pragma ioport  QP1B_INPUT_REG: 0x15d                      //Input register
BYTE            QP1B_INPUT_REG;
#pragma ioport  QP1B_OUTPUT_REG:    0x15e                  //Output register
BYTE            QP1B_OUTPUT_REG;
#pragma ioport  QP1B_INT_REG:       0x0df                  //Interrupt Mask Register
BYTE            QP1B_INT_REG;


//-------------------------------------------------
// QP1B Macro 'Functions'
//-------------------------------------------------

#define QP1B_Start_M \
   QP1B_CONTROL_REG |=  QP1B_CONTROL_REG_START_BIT

#define QP1B_Stop_M  \
   QP1B_CONTROL_REG &= ~QP1B_CONTROL_REG_START_BIT

#define QP1B_EnableInt_M   \
   M8C_EnableIntMask(QP1B_INT_REG, QP1B_INT_MASK)

#define QP1B_DisableInt_M  \
   M8C_DisableIntMask(QP1B_INT_REG, QP1B_INT_MASK)


// end of file QP1B.h
